<?php
	/*
	 * Depends on magpie
	 * http://magpierss.sourceforge.net/
	 */

	require ("modules/mod_overload_html_pages.php");

	$skel["overload_page_version"] = pageIndexVersion();
	$skel["overload_page_lastmodified"] = pageIndexModified();

	$page_title = "Home";

	if (isset($_REQUEST["action"]) && $_REQUEST["action"] == "logout")
	{
		logout($skel);
	}

	if (isLoggedIn())
	{	
		$body .= "<div id=\"logo\"><a href=\"feeds.php\"><img src=\"img/overload_logo.png\" alt=\"overload\" /></a></div>\n";
	} else
	{
		$body .= "<div id=\"logo\"><img src=\"img/overload_logo.png\" alt=\"overload\" /></div>\n";
	}
	$body .= "<div id=\"content\">\n";
	$body .= buildSubnav($skel);
	$body .= "<div id=\"pagebody\">\n";
	$body .= "<h1>Welcome to the overload feedreader</h1>\n";

	if (isset($_REQUEST["user"]) && isset($_REQUEST["password"]))
	{
		$client = "html";
		if (isset($_REQUEST["client"]))
		{
			$client = $_REQUEST["client"];
		}

		$userid = login($skel, $_REQUEST["user"], $_REQUEST["password"]);
		//@TODO: log result of login try!
		if ( $userid > 0)
		{
			/* Login successfull! */
			/* Start new session */
			session_name($skel["session_name"]);
			session_start();

			$_SESSION['username'] = $_REQUEST["user"];
			$_SESSION['userid'] = $userid;
			loadPreferences($skel, $userid);
			$body .= "<p>Logged in successfully</p>\n";

			header("HTTP/1.1 302 Moved Temporary");
			if ($client == "xul")
			{
				header("Location: xul/feedreader.php");
			} else if ($client == "pda")
			{
				header("Location: pda.php?usercode=" . $_SESSION["usercode"]);
			} else
			{
				header("Location: feeds.php");
			}
		} else if ($userid == -2)
		{
			/* User account isn't enabled yet */
			$body .= "<p>Please enable your account first by following the instructions in your e-mail</p>\n";
		} else
		{
			//$body .= "<h1>Error!</h1>\n<p>Not a valid user/pass combo!</p>\n";
			$body .= "<p>Not a valid user/pass combination!</p>\n";
		}

	}


	/* Check if user is logged in */
	if (!isLoggedIn())
	{
		//show login page
		$body .= "<form action=\"index.php\" method=\"post\">\n";
		$body .= "<h2>User</h2><p><input type=\"text\" name=\"user\" /></p>\n<h2>Password</h2><p><input type=\"password\" name=\"password\" /><input type=\"submit\" class=\"button\" value=\"Login\" /></p>\n";
		//$body .= "<p><select name=\"client\"><option value=\"html\">Normal HTML version</option><option value=\"xul\">Rich client [Mozilla only]</option><option value=\"pda\">PDA version</option></select></p>\n";
		$body .= "</form>\n";
		//$body .= "<p>[ <a href=\"xul/\">Rich client [<acronym title=\"eXtensible User-interface Language\">XUL</acronym>]</a> | <a href=\"subscribe.php\">Subscribe as new user</a> ]</p>\n";
		$body .= "<p>[ <a href=\"subscribe.php\">Subscribe as new user</a> | <a href=\"xul/\">Rich client [<acronym title=\"eXtensible User-interface Language\">XUL</acronym>]</a> ]</p>\n";
	} else
	{
		$body .= "<p><a href=\"feeds.php\">Go to your feeds</a></p>\n";
	}


	//$body .= "<p><a href=\"feeds.php\">Feeds</a></p>\n";

	$body .= "<p>Stats: " . getTotalNumberOfItems($skel) . " items in " . getTotalNumberOfFeeds($skel) . " feeds</p>\n";
	//$body .= "<p>overload version " . $skel["overload_version"] . "</p>\n";

	if ($skel["overload_note"] != "")
	{
		$body .= "<h2>News and notes</h2>\n";
		//$body .= "<p>" . $skel["overload_note"] . "</p>\n";
		$body .= $skel["overload_note"];
	}

	$body .= "</div>\n";
	$body .= buildFooter($skel);
	$body .= "</div>\n";

	echo generatePage($skel, $skel["overload_title"] . " | " . $page_title, $body);
?>
