<?php
	/*************************************************

	overload - a PHP RSS feed reader
	Author: Michiel Scholten <mbscholt@aquariusoft.org>
	Copyright (c): 2005 Michiel Scholten, all rights reserved
	Version: 0.0.dev

	 * This library is free software; you can redistribute it and/or
	 * modify it under the terms of the GNU Lesser General Public
	 * License as published by the Free Software Foundation; either
	 * version 2.1 of the License, or (at your option) any later version.
	 *
	 * This library is distributed in the hope that it will be useful,
	 * but WITHOUT ANY WARRANTY; without even the implied warranty of
	 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
	 * Lesser General Public License for more details.
	 *
	 * You should have received a copy of the GNU Lesser General Public
	 * License along with this library; if not, write to the Free Software
	 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

	You may contact the author of 'overload' by e-mail at:
	mbscholt@aquariusoft.org

	The latest version of overload can be obtained from:
	http://aquariusoft.org/html/overload/

	*************************************************/


	$skel["overload_version"] = "0.0.32";
	$skel["overload_lastmodified"] = "2006-01-28";

	include "mod_overload_email.php";

	/*** Generic functions ***/

	if ($skel["overload_secure"])
	{
		$protocol = "https";
	} else
	{
		$protocol = "http";
	}

	$skel["overload_uri"] = $protocol . "://" . $skel["overload_server"] . $skel["overload_serverpath"];

	$skel["parse_starttime"] = getmicrotime();


	$skel["overload_img_newitem"] = "img/newitem.png";
	$skel["overload_img_item"] = "img/item.png";
	$skel["overload_img_flag"] = "img/flag.png";
	$skel["overload_img_flagged"] = "img/flagged.png";

	/*
	 * Session stuff
	 */
	if (isset($_REQUEST[$skel["session_name"]]))
	{
		session_name($skel["session_name"]);
		session_start();
	}

	if (isset($usermodule) && isLoggedIn())
	{
		$skel["overload_nrcolumns_html"] = $_SESSION["overload_nrcolumns_html"];
		$skel["overload_nrcolumns_xul"] = $_SESSION["overload_nrcolumns_xul"];
		$skel["overload_nritemsperpage_html"] = $_SESSION["overload_nritemsperpage_html"];
		$skel["overload_nritemsperpage_xul"] = $_SESSION["overload_nritemsperpage_xul"];
		$skel["overload_itemsperpage"] = $_SESSION["overload_nritemsperpage_html"];
	}

	/*** Fetching feed data for user ***/


	/*
	 * Get all feeds for user $userid, grouped by their respective groups
	 */
	function getFeeds($skel, $userid, $onlysaved = false)
	{
		//return "Not implemented yet";
		$query = 'SELECT DISTINCT overload_feed.id, overload_feed.name, overload_userfeed.name AS feedname, overload_usergroup.name AS groupname, overload_feed.uri, overload_feed.lastupdatesuccessful ' .
			'FROM overload_feed, overload_userfeed, overload_usergroup ' .
			'WHERE overload_userfeed.userid=' . $userid . ' ' .
			'AND overload_userfeed.groupid=overload_usergroup.id ' .
			'AND overload_feed.id=overload_userfeed.feedid ';
			if ($onlysaved)
			{
				$query .= 'AND overload_useritem.issaved=1 ';
			}
			$query .= 'ORDER BY groupname ASC, CONCAT(overload_userfeed.name, overload_feed.name) ASC;';

		$result = doQuery($skel, $query);
		if ( $result != null )
		{
			for ($i = 0; $i < mysql_num_rows( $result ); $i++)
			{
				$row = mysql_fetch_row($result);
				$feeds[$i]["id"] = $row[0];
				$feeds[$i]["feedname"] = $row[1];
				$feeds[$i]["userfeedname"] = $row[2];
				$feeds[$i]["groupname"] = $row[3];
				$feeds[$i]["siteuri"] = $row[4];
				$feeds[$i]["lastupdatesuccessful"] = $row[5];
			}
			return $feeds;
		} else
		{
			return null;
		}
	}


	function getFeed($skel, $feedid)
	{
		$query = 'SELECT overload_feed.id, overload_feed.uri, overload_feed.siteuri, overload_feed.name, overload_feed.subtitle, overload_feed.hasfavicon, overload_feed.feedimage, overload_feed.feedimagedesc, overload_feed.lastupdate, overload_feed.lastupdatesuccessful ' .
			'FROM overload_feed ' . 
			'WHERE overload_feed.id=' . $feedid . ';';

		$result = doQuery($skel, $query);

		if ( $result != null )
		{
			$row = mysql_fetch_row($result);
			$feed["id"] = $row[0];
			$feed["uri"] = $row[1];
			$feed["siteuri"] = $row[2];
			$feed["name"] = $row[3];
			$feed["subtitle"] = $row[4];
			$feed["hasfavicon"] = $row[5];
			$feed["feedimage"] = $row[6];
			$feed["feedimagedesc"] = $row[7];
			$feed["lastupdate"] = $row[8];
			$feed["lastupdatesuccessful"] = $row[9];
			return $feed;
		} else
		{
			return null;
		}
	}


	function getFeedForUser($skel, $userid, $feedid)
	{
		$query = 'SELECT overload_feed.id, overload_feed.uri, overload_feed.siteuri, overload_feed.name, overload_feed.subtitle, overload_feed.hasfavicon, overload_feed.feedimage, overload_feed.feedimagedesc, overload_feed.lastupdate, overload_feed.lastupdatesuccessful, ' .
			'overload_userfeed.name AS userfeedname, overload_userfeed.groupid ' .
			'FROM overload_feed, overload_userfeed ' . 
			'WHERE overload_feed.id=' . $feedid . ' ' .
			'AND overload_userfeed.userid=' . $userid . ' ' .
			'AND overload_userfeed.feedid=overload_feed.id;';

		$result = doQuery($skel, $query);

		if ( $result != null )
		{
			$row = mysql_fetch_row($result);
			$feed["id"] = $row[0];
			$feed["uri"] = $row[1];
			$feed["siteuri"] = $row[2];
			$feed["name"] = $row[3];
			$feed["subtitle"] = $row[4];
			$feed["hasfavicon"] = $row[5];
			$feed["feedimage"] = $row[6];
			$feed["feedimagedesc"] = $row[7];
			$feed["lastupdate"] = $row[8];
			$feed["lastupdatesuccessful"] = $row[9];

			$feed["userfeedname"] = $row[10];
			$feed["groupid"] = $row[11];
			//$feed["lastreaditems"] = $row[11];
			return $feed;
		} else
		{
			return null;
		}
	}


	function getGroups($skel, $userid)
	{
		$query = 'SELECT overload_usergroup.id, overload_usergroup.name, overload_usergroup.folded FROM overload_usergroup ' .
			'WHERE overload_usergroup.userid=' . $userid . ' ORDER BY overload_usergroup.name ASC;';
		$result = doQuery($skel, $query);

		if ( $result != null )
		{
			$groups = array();
			for ($i = 0; $i < mysql_num_rows( $result ); $i++)
			{
				$readitems .= $row[1] . " ";
			
				$row = mysql_fetch_row($result);
				$groups[$i]["id"] = $row[0];
				$groups[$i]["name"] = $row[1];
				$groups[$i]["folded"] = $row[2];
			}
			return $groups;
		} else
		{
			return null;
		}
	}


	function getLatestFeedHeader($skel)
	{
		$feed["id"] = -1;
		$feed["uri"] = "./feeds.php";
		$feed["siteuri"] = "./feeds.php";
		$feed["name"] = "Latest";
		$feed["subtitle"] = "The latest items in your channels";
		$feed["hasfavicon"] = 0;
		$feed["feedimage"] = "";
		$feed["lastupdate"] = date("Y-m-d G:i:s", time());
		$feed["lastupdatesuccessful"] = 1;

		$feed["userfeedname"] = "";
		$feed["groupid"] = -1;
		//$feed["lastreaditems"] = "";
		return $feed;
	}


	function getLatestItemsForUser($skel, $userid, $offset, $nrofitems, $allitems)
	{
		$items = array();
		$readitems = "";
		$isread = "AND overload_useritem.isread=0 ";
		if ($allitems)
		{
			$isread = "";
		}

		$query = 'SELECT overload_item.feedid, overload_item.id, overload_item.title, overload_item.uri, overload_item.content, overload_item.author, overload_item.datetimestamp, overload_item.postmodifiedat, overload_useritem.issaved, overload_useritem.isread, overload_useritem.tags, overload_item.hasuris, overload_feed.name, overload_userfeed.name ' . 
			'FROM overload_item, overload_useritem, overload_feed, overload_userfeed ' .
			'WHERE overload_item.id=overload_useritem.itemid ' .
			'AND overload_useritem.userid=' . $userid . ' ' .
			//'AND overload_item.feedid=' . $feedid . ' ' .
			$isread .
			'AND overload_useritem.isread=0 ' .
			'AND overload_item.feedid=overload_feed.id ' .
			'AND overload_item.feedid=overload_userfeed.feedid ' .
			'AND overload_userfeed.userid=' . $userid . ' ' .
			'ORDER BY overload_item.datetimestamp DESC LIMIT ' . $offset . ', ' . $nrofitems . ';';

		$result = doQuery($skel, $query);

		if ( $result != null )
		{
			for ($i = 0; $i < mysql_num_rows( $result ); $i++)
			{
				$row = mysql_fetch_row($result);

				$readitems .= $row[1] . " ";
			
				$items[$i]["feedid"] = $row[0];
				$items[$i]["id"] = $row[1];
				$items[$i]["title"] = $row[2];
				$items[$i]["uri"] = $row[3];
				$items[$i]["content"] = $row[4];
				$items[$i]["author"] = $row[5];
				$items[$i]["datetimestamp"] = $row[6];
				$items[$i]["postmodifiedat"] = $row[7];
				$items[$i]["issaved"] = $row[8];
				$items[$i]["isread"] = $row[9];
				$items[$i]["tags"] = $row[10];
				$items[$i]["hasuris"] = $row[11];
				$items[$i]["feedname"] = $row[12];
				$items[$i]["userfeedname"] = $row[13];
			}
			return $items;
		} else
		{
			return null;
		}
	}



	function getRandomFeedHeader($skel)
	{
		$feed["id"] = -1;
		$feed["uri"] = "./feeds.php";
		$feed["siteuri"] = "./feeds.php";
		$feed["name"] = "Random selection";
		$feed["subtitle"] = "This is a random selection from your unread items";
		$feed["hasfavicon"] = 0;
		$feed["feedimage"] = "";
		$feed["lastupdate"] = date("Y-m-d G:i:s", time());
		$feed["lastupdatesuccessful"] = 1;

		$feed["userfeedname"] = "";
		$feed["groupid"] = -1;
		//$feed["lastreaditems"] = "";
		return $feed;
	}


	function getRandomItemsForUser($skel, $userid, $nrofitems, $allitems)
	{
		$items = array();
		$readitems = "";
		$isread = "AND overload_useritem.isread=0 ";
		if ($allitems)
		{
			$isread = "";
		}

		$query = 'SELECT overload_item.feedid, overload_item.id, overload_item.title, overload_item.uri, overload_item.content, overload_item.author, overload_item.datetimestamp, overload_item.postmodifiedat, overload_useritem.issaved, overload_useritem.isread, overload_useritem.tags, overload_item.hasuris, overload_feed.name, overload_userfeed.name ' . 
			'FROM overload_item, overload_useritem, overload_feed ' .
			'WHERE overload_item.id=overload_useritem.itemid ' .
			'AND overload_useritem.userid=' . $userid . ' ' .
			//'AND overload_item.feedid=' . $feedid . ' ' .
			$isread .
			'AND overload_useritem.isread=0 ' .
			'AND overload_item.feedid=overload_feed.id ' .
			'AND overload_item.feedid=overload_userfeed.id ' .
			'AND overload_userfeed.userid=' . $userid . ' ' .
			'ORDER BY RAND() LIMIT ' . $nrofitems . ';';

		$result = doQuery($skel, $query);
		
		if ( $result != null )
		{
			for ($i = 0; $i < mysql_num_rows( $result ); $i++)
			{
				$row = mysql_fetch_row($result);

				$readitems .= $row[1] . " ";
			
				$items[$i]["feedid"] = $row[0];
				$items[$i]["id"] = $row[1];
				$items[$i]["title"] = $row[2];
				$items[$i]["uri"] = $row[3];
				$items[$i]["content"] = $row[4];
				$items[$i]["author"] = $row[5];
				$items[$i]["datetimestamp"] = $row[6];
				$items[$i]["postmodifiedat"] = $row[7];
				$items[$i]["issaved"] = $row[8];
				$items[$i]["isread"] = $row[9];
				$items[$i]["tags"] = $row[10];
				$items[$i]["hasuris"] = $row[11];
				$items[$i]["feedname"] = $row[12];
				$items[$i]["userfeedname"] = $row[13];
			}
			return $items;
		} else
		{
			return null;
		}
	}



	/*
	 * Same as getItems, but then with use of the overload_useritem table to get the unread items for user $userid
	 */
	function getItemsForUser($skel, $userid, $feedid, $offset, $allitems = false, $limititems = true, $filtersaved = false)
	{
		$items = array();
		$readitems = "";
		$isread = "AND overload_useritem.isread=0 ";
		if ($allitems)
		{
			$isread = "";
		}

		$issaved = "";
		if ($filtersaved)
		{
			$issaved = "AND overload_useritem.issaved=1 ";
		}

		$query = 'SELECT overload_item.feedid, overload_item.id, overload_item.title, overload_item.uri, overload_item.content, overload_item.author, overload_item.datetimestamp, overload_item.postmodifiedat, overload_useritem.issaved, overload_useritem.isread, overload_useritem.tags, overload_item.hasuris, overload_feed.name, overload_userfeed.name ' . 
		//$query = 'SELECT overload_item.feedid, overload_item.id, overload_item.title, overload_item.uri, overload_item.content, overload_item.author, overload_item.datetimestamp, overload_item.postmodifiedat, overload_useritem.issaved, overload_useritem.isread, overload_useritem.tags, overload_item.hasuris ' . 
			'FROM overload_item, overload_useritem, overload_feed, overload_userfeed ' .
			//'FROM overload_item, overload_useritem ' .
			'WHERE overload_item.id=overload_useritem.itemid ' .
			'AND overload_useritem.userid=' . $userid . ' ' .
			'AND overload_item.feedid=' . $feedid . ' ' .
			$isread .
			$issaved .
			' AND overload_feed.id=overload_item.feedid ' .
			'AND overload_userfeed.feedid=overload_item.feedid ' .
			'AND overload_userfeed.userid=' . $userid . ' ' .
			//' AND overload_item.feedid=overload_feed.id ' .
			//'AND overload_item.feedid=overload_userfeed.feedid ' .
			//'AND overload_feed.id=overload_userfeed.feedid ' .
			//' AND overload_feed.id=' . $feedid . ' ' .
			//'AND overload_userfeed.feedid=' . $feedid . ' ' .
			'ORDER BY overload_item.datetimestamp DESC ';
			if ($limititems)
			{
				$query .= 'LIMIT ' . $offset . ', ' . $skel["overload_itemsperpage"];
			}
			$query .= ';';

		$result = doQuery($skel, $query);

		if ( $result != null )
		{
			for ($i = 0; $i < mysql_num_rows( $result ); $i++)
			{
				$row = mysql_fetch_row($result);

				$readitems .= $row[1] . " ";
			
				$items[$i]["feedid"] = $row[0];
				$items[$i]["id"] = $row[1];
				$items[$i]["title"] = $row[2];
				$items[$i]["uri"] = $row[3];
				$items[$i]["content"] = $row[4];
				$items[$i]["author"] = $row[5];
				$items[$i]["datetimestamp"] = $row[6];
				$items[$i]["postmodifiedat"] = $row[7];
				$items[$i]["issaved"] = $row[8];
				$items[$i]["isread"] = $row[9];
				$items[$i]["tags"] = $row[10];
				$items[$i]["hasuris"] = $row[11];
				$items[$i]["feedname"] = $row[12];
				$items[$i]["userfeedname"] = $row[13];
			}
			return $items;
		} else
		{
			return null;
		}
	}


	/*
	 * Look up the requested item only
	 */
	function getItem($skel, $userid, $itemid)
	{
		$query = 'SELECT overload_item.feedid, overload_item.id, overload_item.title, overload_item.uri, overload_item.content, overload_item.author, overload_item.datetimestamp, overload_item.postmodifiedat, overload_useritem.issaved, overload_useritem.isread, overload_useritem.tags, overload_item.hasuris, overload_feed.name, overload_userfeed.name ' . 
			'FROM overload_item, overload_useritem, overload_feed, overload_userfeed ' .
			'WHERE overload_item.id=overload_useritem.itemid ' .
			'AND overload_useritem.userid=' . $userid . ' ' .
			'AND overload_item.id=' . $itemid . ' ' .
			'AND overload_item.feedid=overload_feed.id ' . ' ' .
			'AND overload_item.feedid=overload_userfeed.feedid ' .
			'AND overload_userfeed.userid=' . $userid . ' ' .
			';';

		//echo $query;

		$result = doQuery($skel, $query);
		
		if ( $result != null )
		{
			if (mysql_num_rows( $result ) > 0)
			{
				$row = mysql_fetch_row($result);

				$item["feedid"] = $row[0];
				$item["id"] = $row[1];
				$item["title"] = $row[2];
				$item["uri"] = $row[3];
				$item["content"] = $row[4];
				$item["author"] = $row[5];
				$item["datetimestamp"] = $row[6];
				$item["postmodifiedat"] = $row[7];
				$item["issaved"] = $row[8];
				$item["isread"] = $row[9];
				$item["tags"] = $row[10];
				$item["hasuris"] = $row[11];
				$item["feedname"] = $row[12];
				$item["userfeedname"] = $row[13];
				return $item;
			}
		}
		return null;
	}

	function getItems($skel, $userid, $itemids)
	{
		$items = array();

		$query = 'SELECT overload_item.feedid, overload_item.id, overload_item.title, overload_item.uri, overload_item.content, overload_item.author, overload_item.datetimestamp, overload_item.postmodifiedat, overload_useritem.issaved, overload_useritem.isread, overload_useritem.tags, overload_item.hasuris ' . 
			'FROM overload_item, overload_useritem ' .
			'WHERE overload_item.id=overload_useritem.itemid ' .
			'AND overload_useritem.userid=' . $userid . ' ' .
			'AND (';
		for ($i = 0; $i < count($itemids); $i++)
		{
			$query .= 'overload_item.id=' . $itemids[$i] . ' ';
			if ($i < (count($itemids) - 1))
			{
				$query .= 'OR ';
			}
		}
		$query .= ') ' .
			'ORDER BY overload_item.datetimestamp DESC;';

		$result = doQuery($skel, $query);
		
		if ( $result != null )
		{
			for ($i = 0; $i < mysql_num_rows( $result ); $i++)
			{
				$row = mysql_fetch_row($result);

				$readitems .= $row[1] . " ";
			
				$items[$i]["feedid"] = $row[0];
				$items[$i]["id"] = $row[1];
				$items[$i]["title"] = $row[2];
				$items[$i]["uri"] = $row[3];
				$items[$i]["content"] = $row[4];
				$items[$i]["author"] = $row[5];
				$items[$i]["datetimestamp"] = $row[6];
				$items[$i]["postmodifiedat"] = $row[7];
				$items[$i]["issaved"] = $row[8];
				$items[$i]["isread"] = $row[9];
				$items[$i]["tags"] = $row[10];
				$items[$i]["hasuris"] = $row[11];
			}
			return $items;
		}
		return null;
	}


	function setItemsRead($skel, $userid, $items)
	{

		$itemids = explode(" ", $items);
		$query = 'UPDATE overload_useritem ' .
			'SET isread=1 ' .
			//'WHERE overload_useritem.userid=' . $userid . ' AND (';
			'WHERE (';
		$firstitem = true;
		foreach ($itemids as $itemid)
		{
			if ($itemid != "")
			{
				if (!$firstitem)
				{
					$query .= ' OR ';
				}
				$query .= 'overload_useritem.itemid=' . $itemid . ' ';
				if ($firstitem)
				{
					$firstitem = false;
				}
			}
		}
		//$query .= ');';
		$query .= ') AND overload_useritem.userid=' . $userid . ';';
		doQuery($skel, $query);

/*
		$itemids = explode(" ", $items);
		foreach ($itemids as $itemid)
		{
			if ($itemid != "")
			{
				$query = 'UPDATE overload_useritem ' .
					'SET isread=1 ' .
					'WHERE overload_useritem.itemid=' . $itemid . ' ' .
					'AND overload_useritem.userid=' . $userid . ';';
				doQuery($skel, $query);
			}
		}
*/
	}


	function setFeedRead($skel, $userid, $feedid)
	{
		$query = 'UPDATE overload_useritem, overload_item ' .
			'SET overload_useritem.isread=1 ' .
			'WHERE overload_useritem.itemid = overload_item.id ' .
			'AND overload_item.feedid = ' . $feedid . ' ' .
			'AND overload_useritem.userid=' . $userid . ';';
//echo $query;
		doQuery($skel, $query);
	}


	function setItemsUnread($skel, $userid, $items)
	{
		$itemids = explode(" ", $items);
		foreach ($itemids as $itemid)
		{
			if ($itemid != "")
			{
				$query = 'UPDATE overload_useritem ' .
					'SET isread=0 ' .
					'WHERE overload_useritem.itemid=' . $itemid . ' ' .
					'AND overload_useritem.userid=' . $userid . ';';
				doQuery($skel, $query);
			}
		}
	}


	function getFindItemsHeader($skel, $searchkey)
	{
		$feed["id"] = -1;
		$feed["uri"] = "./feeds.php";
		$feed["siteuri"] = "./feeds.php";
		$feed["name"] = "Find";
		$feed["subtitle"] = "Results of your search on '" . $searchkey . "'";
		$feed["hasfavicon"] = 0;
		$feed["feedimage"] = "";
		$feed["lastupdate"] = date("Y-m-d G:i:s", time());
		$feed["lastupdatesuccessful"] = 1;

		$feed["userfeedname"] = "";
		$feed["groupid"] = -1;
		return $feed;
	}


	function findItems($skel, $userid, $query)
	{
		$items = array();

		$query = 'SELECT overload_item.feedid, overload_item.id, overload_item.title, overload_item.uri, overload_item.content, overload_item.author, overload_item.datetimestamp, overload_item.postmodifiedat, overload_useritem.issaved, overload_useritem.isread, overload_useritem.tags, overload_item.hasuris ' . 
			'FROM overload_item, overload_useritem ' .
			'WHERE overload_item.id=overload_useritem.itemid ' .
			'AND overload_useritem.userid=' . $userid . ' ' .
			'AND (overload_item.content LIKE \'%' . mysql_real_escape_string($query) . '%\' ' .
			'OR overload_item.title LIKE \'%' . mysql_real_escape_string($query) . '%\') ' .
			'ORDER BY overload_item.datetimestamp DESC;';

		$result = doQuery($skel, $query);
		
		if ( $result != null )
		{
			for ($i = 0; $i < mysql_num_rows( $result ); $i++)
			{
				$row = mysql_fetch_row($result);

				$readitems .= $row[1] . " ";
			
				$items[$i]["feedid"] = $row[0];
				$items[$i]["id"] = $row[1];
				$items[$i]["title"] = $row[2];
				$items[$i]["uri"] = $row[3];
				$items[$i]["content"] = $row[4];
				$items[$i]["author"] = $row[5];
				$items[$i]["datetimestamp"] = $row[6];
				$items[$i]["postmodifiedat"] = $row[7];
				$items[$i]["issaved"] = $row[8];
				$items[$i]["isread"] = $row[9];
				$items[$i]["tags"] = $row[10];
				$items[$i]["hasuris"] = $row[11];
			}
			return $items;
		}
		return null;
	}


	function findRelatedItems($skel, $userid, $itemids)
	{
		$items = array();

		$query = 'SELECT overload_containsuri.itemid, cu2.itemid ' . 
			'FROM overload_containsuri, overload_containsuri AS cu2 ' .
			'WHERE overload_containsuri.uri=cu2.uri ' .
			'AND (';
		for ($i = 0; $i < count($itemids); $i++)
		{
			$query .= '(overload_containsuri.itemid=' . $itemids[$i] . ' AND cu2.itemid!=' . $itemids[$i] . ') ';
			if ($i < (count($itemids) - 1))
			{
				$query .= 'OR ';
			}
		}
		$query .= ') ' .
			//'GROUP BY overload_containsuri.itemid;';
			//'ORDER BY overload_containsuri.itemid;';
			//'ORDER BY cu2.itemid, overload_containsuri.itemid;';
			'ORDER BY overload_containsuri.itemid, cu2.itemid DESC;';

		$result = doQuery($skel, $query);

		$itemids = array();
		if ( $result != null )
		{
			$thisItem = -1;
			$previousRelatedItem = -1;
			$counter = 0;
			$counterforthisitem = 0;
			for ($i = 0; $i < mysql_num_rows( $result ); $i++)
			{
				$row = mysql_fetch_row($result);

				if ($row[0] != $thisItem)
				{
					$counterforthisitem = 0;
					$thisItem = $row[0];
					$previousRelatedItem = -1;
				}

				if ($row[1] != $previousRelatedItem && $counterforthisitem <= 10)
				{
					$previousRelatedItem = $row[1];

					$items[$counter]["thisitem"] = $row[0];
					$items[$counter]["itemid"] = $row[1];
					$itemids[$counter] = $row[1];
					$counter++;
					$counterforthisitem++;
				}
			}
			// @TODO: somehow compensate for the userid. Now the user can have
			//  less then 10 items when more are available for him, only because they are
			//  already filtered away by skipping them
			if (count($itemids) > 0)
			{
				$relatedItems = getItems($skel, $userid, $itemids);
				for ($i = 0; $i < count($items); $i++)
				{
					for ($j = 0; $j < count($relatedItems); $j++)
					{
						if ($items[$i]["itemid"] == $relatedItems[$j]["id"])
						{
							$items[$i]["item"] = $relatedItems[$j];
						}
					}
				}
				return $items;
			}
		}

		return null;
	}


	function findLinkingItemsForURI($skel, $userid, $uri)
	{
		$items = array();
/*
		$query = 'SELECT overload_item.feedid, overload_item.id, overload_item.title, overload_item.uri, overload_item.content, overload_item.datetimestamp, overload_item.postmodifiedat, overload_useritem.issaved, overload_useritem.isread ' . 
			'FROM overload_item, overload_useritem ' .
			'WHERE overload_item.id=overload_useritem.itemid ' .
			'AND overload_useritem.userid=' . $userid . ' ' .
			'AND overload_item.uri="' .  mysql_real_escape_string($uri) . '" ' .
			'ORDER BY overload_item.datetimestamp DESC;';
*/

		$query = 'SELECT DISTINCT overload_item.feedid, overload_item.id, overload_item.title, overload_item.uri, overload_item.content, overload_item.author, overload_item.datetimestamp, overload_item.postmodifiedat, overload_useritem.issaved, overload_useritem.isread, overload_feed.id, overload_feed.name, overload_userfeed.name ' . 
			'FROM overload_item, overload_useritem, overload_containsuri, overload_feed, overload_userfeed ' .
			'WHERE overload_containsuri.itemid=overload_item.id ' .
			'AND overload_item.id=overload_useritem.itemid ' .
			'AND overload_useritem.userid=' . $userid . ' ' .
			'AND overload_containsuri.uri="' .  mysql_real_escape_string($uri) . '" ' .
			'AND overload_item.feedid=overload_feed.id ' .
			'AND overload_userfeed.feedid=overload_feed.id ' .
			'ORDER BY overload_item.datetimestamp DESC;';

		//echo $query . "\n";

		$result = doQuery($skel, $query);
		
		if ( $result != null )
		{
			for ($i = 0; $i < mysql_num_rows( $result ); $i++)
			{
				$row = mysql_fetch_row($result);

				$readitems .= $row[1] . " ";
			
				$items[$i]["feedid"] = $row[0];
				$items[$i]["id"] = $row[1];
				$items[$i]["title"] = $row[2];
				$items[$i]["uri"] = $row[3];
				$items[$i]["content"] = $row[4];
				$items[$i]["author"] = $row[5];
				$items[$i]["datetimestamp"] = $row[6];
				$items[$i]["postmodifiedat"] = $row[7];
				$items[$i]["issaved"] = $row[8];
				$items[$i]["isread"] = $row[9];
				//hasuris?

				$items[$i]["feedid"] = $row[10];
				$items[$i]["feedname"] = $row[11];
				$items[$i]["userfeedname"] = $row[12];
			}
			return $items;
		}
		return null;
	}


	function findLinkingItems($skel, $userid, $itemids, $uris)
	{
		$items = array();
/*
		$query = 'SELECT overload_containsuri.itemid, cu2.itemid ' . 
			'FROM overload_containsuri, overload_containsuri AS cu2 ' .
			'WHERE overload_containsuri.uri=cu2.uri ' .
			'AND (';
		for ($i = 0; $i < count($itemids); $i++)
		{
			$query .= '(overload_containsuri.itemid=' . $itemids[$i] . ' AND cu2.itemid!=' . $itemids[$i] . ') ';
			if ($i < (count($itemids) - 1))
			{
				$query .= 'OR ';
			}
		}
		$query .= ') ' .
			'ORDER BY overload_containsuri.itemid, cu2.itemid;';
*/
/*
		$query = 'SELECT overload_containsuri.itemid, cu2.itemid FROM overload_containsuri, overload_containsuri AS cu2 '.
			'WHERE overload_containsuri.uri=cu2.uri ' .
			'AND (';
		for ($i = 0; $i < count($itemids); $i++)
		{
			$query .= '(overload_containsuri.itemid=' . $itemids[$i] . ' AND cu2.itemid!=' . $itemids[$i] . ') ';
			if ($i < (count($itemids) - 1))
			{
				$query .= 'OR ';
			}
		}
		$query .= ');';
*/

		$query = 'SELECT overload_containsuri.itemid, overload_containsuri.uri' .
			'FROM overload_containsuri' .
			'WHERE ';
		for ($i = 0; $i < count($uris); $i++)
		{
			$query .= '(overload_containsuri.itemid!=' . $itemids[$i] . ' AND overload_containsuri.uri=' . $uris[$i] . ') ';
			if ($i < (count($itemids) - 1))
			{
				$query .= 'OR ';
			}
		}
		$query .= ') ' .
			'ORDER BY overload_containsuri.itemid DESC, overload_containsuri.uri ASC;';

		$result = doQuery($skel, $query);

		$itemids = array();
		if ( $result != null )
		{
			$thisItem = -1;
			$previousRelatedItem = -1;
			$counter = 0;
			for ($i = 0; $i < mysql_num_rows( $result ); $i++)
			{
				$row = mysql_fetch_row($result);

				if ($row[0] != $thisItem)
				{
					$thisItem = $row[0];
					$previousRelatedItem = -1;
				}

				if ($row[1] != $previousRelatedItem)
				{
					$previousRelatedItem = $row[1];

					$items[$counter]["thisitem"] = $row[0];
					$items[$counter]["itemid"] = $row[1];
					$itemids[$counter] = $row[1];
					$counter++;
				}
			}
			if (count($itemids) > 0)
			{
				$relatedItems = getItems($skel, $userid, $itemids);
				for ($i = 0; $i < count($items); $i++)
				{
					for ($j = 0; $j < count($relatedItems); $j++)
					{
						if ($items[$i]["itemid"] == $relatedItems[$j]["id"])
						{
							$items[$i]["item"] = $relatedItems[$j];
						}
					}
				}
				return $items;
			}
		}

		return null;
	}


	/*
	 * Add item to Saved items list
	 */
	function saveItem($skel, $userid, $itemid)
	{
		if (!isLoggedIn())
		{
			return;
		}
		$query = 'UPDATE overload_useritem SET issaved=1 WHERE userid=' . $userid . ' AND itemid=' . $itemid . ';';
		doQuery($skel, $query);
	}


	/*
	 * Remove item from Saved items list
	 */
	function unsaveItem($skel, $userid, $itemid)
	{
		if (!isLoggedIn())
		{
			return;
		}
		$query = 'UPDATE overload_useritem SET issaved=0 WHERE userid=' . $userid . ' AND itemid=' . $itemid . ';';
		doQuery($skel, $query);
	}


	function getNumberOfUnreadItems($skel, $userid, $feedid)
	{
		if ($userid < 1)
		{
			/* @TODO: hack for using loginless crawling */
			$userid = 1;
		}
		$query = 'SELECT count(*) FROM overload_item, overload_useritem ' .
			'WHERE overload_useritem.isread=0 ' .
			'AND overload_useritem.userid=' . $userid . ' ' .
			'AND overload_item.feedid=' . $feedid . ' ' .
			'AND overload_item.id=overload_useritem.itemid;';
		$result = doQuery($skel, $query);
		if ( $result != null )
		{
			$row = mysql_fetch_row($result);
			return $row[0];
		} else
		{
			return -1;
		}
	}

	function getNumberOfUnreadItemsPerFeed($skel, $userid)
	{
		if ($userid < 1)
		{
			/* @TODO: hack for using loginless crawling */
			$userid = 1;
		}
		$query = 'SELECT overload_item.feedid, count(*) FROM overload_item, overload_useritem ' .
			'WHERE overload_useritem.isread=0 ' .
			'AND overload_useritem.userid=' . $userid . ' ' .
			'AND overload_item.id=overload_useritem.itemid ' .
			'GROUP BY overload_item.feedid;';
		$result = doQuery($skel, $query);
		if ( $result != null )
		{
			$feeds = array();
			for ($i = 0; $i < mysql_num_rows( $result ); $i++)
			{
				$row = mysql_fetch_row($result);
				$feeds[$row[0]]["unread"] = $row[1];
			}
			return $feeds;
		} else
		{
			return -1;
		}
	}

	function getNumberOfSavedItems($skel, $userid, $feedid)
	{
		if ($userid < 1)
		{
			/* @TODO: hack for using loginless crawling */
			$userid = 1;
		}
		$query = 'SELECT count(*) FROM overload_item, overload_useritem ' .
			'WHERE overload_useritem.userid=' . $userid . ' ' .
			'AND overload_item.feedid=' . $feedid . ' ' .
			'AND overload_item.id=overload_useritem.itemid ' .
			'AND overload_useritem.issaved=1;';
		$result = doQuery($skel, $query);
		if ( $result != null )
		{
			$row = mysql_fetch_row($result);
			return $row[0];
		} else
		{
			return -1;
		}
	}

	function getNumberOfItems($skel, $userid, $feedid)
	{
		if ($userid < 1)
		{
			/* @TODO: hack for using loginless crawling */
			$userid = 1;
		}
		$query = 'SELECT count(*) FROM overload_item, overload_useritem ' .
			'WHERE overload_useritem.userid=' . $userid . ' ' .
			'AND overload_item.feedid=' . $feedid . ' ' .
			'AND overload_item.id=overload_useritem.itemid;';
		$result = doQuery($skel, $query);
		if ( $result != null )
		{
			$row = mysql_fetch_row($result);
			return $row[0];
		} else
		{
			return -1;
		}
	}

	function getTotalNumberOfFeedsForUser($skel, $userid)
	{
		$query = 'SELECT count(*) FROM overload_userfeed WHERE overload_userfeed.userid=' . $userid . ';';
		$result = doQuery($skel, $query);
		if ( $result != null )
		{
			$row = mysql_fetch_row($result);
			return $row[0];
		} else
		{
			return -1;
		}
	}


	function getTotalNumberOfUnreadItemsForUser($skel, $userid)
	{
		$query = 'SELECT count(*) FROM overload_useritem ' .
			'WHERE overload_useritem.userid=' . $userid . ' ' .
			'AND overload_useritem.isread=0;';
		$result = doQuery($skel, $query);
		if ( $result != null )
		{
			$row = mysql_fetch_row($result);
			return $row[0];
		} else
		{
			return -1;
		}
	}

	function getTotalNumberOfFeeds($skel)
	{
		$query = 'SELECT count(*) FROM overload_feed;';
		$result = doQuery($skel, $query);
		if ( $result != null )
		{
			$row = mysql_fetch_row($result);
			return $row[0];
		} else
		{
			return -1;
		}
	}


	function getTotalNumberOfItems($skel)
	{
		$query = 'SELECT count(*) FROM overload_item;';
		$result = doQuery($skel, $query);
		if ( $result != null )
		{
			$row = mysql_fetch_row($result);
			return $row[0];
		} else
		{
			return -1;
		}
	}


	/*** Management functions ***/

	/*
	 * Maps uri to feedid if feed is present in DB
	 */
	function feedUriToID($skel, $uri)
	{
		$query = 'SELECT overload_feed.id FROM overload_feed WHERE uri="' . mysql_real_escape_string($uri) . '";';
		$result = doQuery($skel, $query);
		if ( $result != null && mysql_num_rows($result) > 0 )
		{
			$row = mysql_fetch_row($result);
			return $row[0];
		} else
		{
			return -1;
		}
	}



	function addFeed($skel, $userid, $groupid, $uri, $feedname)
	{
		if ($uri == "")
		{
			return "Error: fill in a uri!";
		}
		/* First check whether we already have $uri as feed */
		$feedid = feedUriToID($skel, $uri);
//		echo "feedid == " . $feedid . "\n";

		if ($feedid == -1)
		{
			/* Feed doesn't exist in DB yet */
			$fetchuri = $uri;
			$uri_pieces = parse_url($uri);
			if ($uri_pieces["host"] == "aquariusoft.org" || $uri_pieces["host"] == "www.aquariusoft.org")
			{
				$fetchuri = str_ireplace("://aquariusoft.org", "://localhost", $fetchuri);
				$fetchuri = str_ireplace("://www.aquariusoft.org", "://localhost", $fetchuri);
			}
			$feed = fetch_rss($fetchuri);

			$feedinfo = getFeedInfo($skel, $feed, $uri);
			$feedinfo["uri"] = $uri;
//print_r($feedinfo);

			/* Add to list of feeds */
			$query = 'INSERT INTO overload_feed ' .
				'SET uri="' . mysql_real_escape_string($feedinfo["uri"]) . '", ' .
				'siteuri="' . mysql_real_escape_string($feedinfo["siteuri"]) . '", ' .
				'name="' . mysql_real_escape_string($feedinfo["name"]) . '", ' .
				'subtitle="' . mysql_real_escape_string($feedinfo["subtitle"]) . '", ' .
				'feedimage="' . mysql_real_escape_string($feedinfo["feedimage"]) . '", ' .
				'feedimagedesc="' . mysql_real_escape_string($feedinfo["feedimagedesc"]) . '", ' .
				'added="' . date("Y-m-d G:i:s", time()) . '";';
			$result = doQuery($skel, $query);
//			echo $query . "\n";
			$feedid = getLastInsertID($skel);
		}
		/* Add to user's list */

		$query = 'INSERT INTO overload_userfeed SET ' .
			'userid=' . $userid . ', ' .
			'feedid=' . $feedid . ', ' .
			'groupid=' . $groupid . ', ' .
			'name="' . mysql_real_escape_string($feedname) . '", ' .
			'timestamp="' . date("Y-m-d G:i:s", time()) . '";';
//			echo $query . "\n";
		$result = doQuery($skel, $query);
		if ($result == null || $result != 1)
		{
			return "Error while adding new feed to users list";
		}
		return;
	}

	function addGroup($skel, $userid, $name)
	{
		/* Check if it already exists */
		$query = 'SELECT overload_usergroup.id FROM overload_usergroup ' .
			'WHERE overload_usergroup.name="' . mysql_real_escape_string($name) . '" ' .
			'AND overload_usergroup.userid=' . $userid . ';';
		$result = doQuery($skel, $query);
		if ( $result != null && mysql_num_rows($result) > 0 )
		{
			$row = mysql_fetch_row($result);
			return $row[0];
		} else
		{
			$query = 'INSERT INTO overload_usergroup ' .
				'SET userid=' . $userid . ', name="' . mysql_real_escape_string($name) . '", ' .
				'timestamp="' . date("Y-m-d G:i:s", time()) . '";';
			$result_group = doQuery($skel, $query);
			return getLastInsertID($skel);
		}
	}


	function getFeedname($item)
	{
		if (isset($item["userfeedname"]) && $item["userfeedname"] != "")
		{
			return $item["userfeedname"];
		} else
		{
			return $item["feedname"];
		}
	}

	function getEnclosures($skel, $itemid)
	{
		$enclosures = array();
		$query = 'SELECT id, uri, length, mimetype ' .
			'FROM overload_enclosure ' .
			'WHERE itemid=' . $itemid . ';';
		$result = doQuery($skel, $query);
		if ( $result != null && mysql_num_rows($result) > 0 )
		{
			for ($i = 0; $i < mysql_num_rows( $result ); $i++)
			{
				$row = mysql_fetch_row($result);

				$enclosures[$i]["id"] = $row[0];
				$enclosures[$i]["uri"] = $row[1];
				$enclosures[$i]["length"] = $row[2];
				$enclosures[$i]["mimetype"] = $row[3];
			}
			return $enclosures;
			
		} else
		{
			return null;
		}
	}

?>
