<?php
	$skel["overload_pages_version"] = "0.0.09";
	$skel["overload_pages_lastmodified"] = "2006-01-13";

	$skel["overload_title"] = "overload feedreader";

	require ("config.php");

	require ("mod_overload_html.php");
	require ("mod_toolkit.php");
	require ("mod_db.php");
	require ("mod_overload_user.php");
	require ("mod_overload.php");
	require ("mod_logging.php");

	//header("content-type:application/vnd.mozilla.xul+xml; charset=utf8");
	header("charset=utf8");

	/*
	 * Channel overview/detail page
	 */
//	function pageFeedsVersion() { return "0.0.18"; }
//	function pageFeedsModified() { return "2005-06-29"; }
//	function pageFeeds($skel, $feedid, $page, $itemid = -1)
//	{
		//
//	}


	/*
	 * Start page
	 */
	function pageIndexVersion() { return "0.0.14"; }
	function pageIndexModified() { return "2005-08-08"; }
	function pageIndex($skel, $feedid, $page, $itemid = -1)
	{
		//
	}


	/*
	 * "Subscribe as new user" page
	 */
	function pageSubscribeVersion() { return "0.0.08"; }
	function pageSubscribeModified() { return "2006-01-12"; }
	function pageSubscribe($skel, $username, $email, $password, $password2)
	{
		$body = "";
		$enabling = false;
		if (isset($_REQUEST["enable"]))
		{
			/* @TODO: check whether user already was enabled? or has a different status? */
			$usercode = $_REQUEST["enable"];
			$userid = usercodeToUserID($skel, $usercode);
			if ($userid > 0)
			{
				enableUser($skel, $userid);
				$enabling = true;
				$body .= "<div id=\"pagebody\">\n";
				$body .= "<h1>Successfully registered</h1>\n<p>Your account has been enabled. You can now log in and start using your account. Enjoy!</p>\n<p><a href=\"./\">Go to index page</a></p>\n";
			}
		}

		/* Check if user is logged in */
		if (!isLoggedIn() && $enabling == false)
		{
			$error = "";
			$subscribed = false;

			if ($username != null && $email != null && $password != null && $password2 != null)
			{
				if ($password != $password2)
				{
					$error = "Passwords do not match";
				} else if ($username == "")
				{
					$error = "Fill in a username";
				} else if ($email == "")
				{
					$error = "Fill in a valid e-mail address";
				} else if ($password == "")
				{
					$error = "Fill in a password";
				} else
				{
					$ip = getenv("REMOTE_ADDR");
					$error = addOverloadUser($skel, $username, $password, $email, $ip);
				}
				if ($error == "")
				{
					//succeeded, say so
					$body .= "<div id=\"pagebody\">\n";
					$body .= "<h1>Successfully subscribed as new user</h1>\n";
					$body .= "<p>Instructions how to enable your account have been sent to your e-mail address: '" . $email . "'</p>\n<p><a href=\"./\">Go to index page</a></p>\n";
					$subscribed = true;
				}
			}

			if ($subscribed == false)
			{
				$body .= "<div id=\"pagebody\">\n";
				$body .= "<h1>Subscribe as new user</h1>\n";
				if ($error != "")
				{
					$body .= "<p>Error: " . $error . "</p>\n";
				}
				$body .= "<form action=\"subscribe.php\" method=\"post\">\n";
				$body .= "<h2>Your e-mail address</h2><p><input type=\"text\" name=\"email\" value=\"" . $email . "\" /></p>\n";
				$body .= "<h2>Desired username</h2><p><input type=\"text\" name=\"user\" value=\"" . $user . "\" /></p>\n<h2>Password</h2><p><input type=\"password\" name=\"password\" /></p>\n<h2>Retype password</h2><p><input type=\"password\" name=\"password2\" /><input type=\"submit\" class=\"button\" value=\"Subscribe\" />\n";
				$body .= "</form>\n";
			}
		} else if ($enabling == false)
		{
			// @TODO: redirect to feeds.php [?]
			$body .= "<div id=\"pagebody\">\n";
			$body .= "<h1>You are already subscribed as user</h1>\n";
			$body .= "<p>If you want to subscribe as new user, please <a href=\"feeds.php?action=logout\">log out first</a> or <a href=\"feeds.php\">go to your feeds</a></p>\n";
		}
		return $body;
	}


	/*
	 * Channel overview/detail page
	 */
	function pageFeedsVersion() { return "0.0.21"; }
	function pageFeedsModified() { return "2006-01-05"; }
	function pageFeeds($skel, $feedid, $currentpage, $itemid = -1)
	{
		$body = "";
		$timer = getmicrotime();

		/* Check if user is logged in */
		if (!isLoggedIn())
		{
			$body .= buildNotLoggedIn($skel);
		} else
		{
			$userid = $_SESSION["userid"];
			$totalpages = 1;

			if ($feedid < 0)
			{
				/* Newest items overview */
				$totalpages = ceil(getTotalNumberOfUnreadItemsForUser($skel, $userid) / $skel["overload_itemsperpage"]);
			} else
			{
				$totalpages = ceil(getNumberOfUnreadItems($skel, $userid, $feedid) / $skel["overload_itemsperpage"]);
			}

			if ($currentpage > $totalpages)
			{
				$currentpage = $totalpages;
			}
			
			$offset = ($currentpage - 1) * $skel["overload_itemsperpage"];
			if ($offset < 0)
			{
				$offset = 0;
			}
			/* We only want the unread items */
			$allitems = false;

			/* Check for the clean url [ /page/sectionname/pagename/ instead of index.php?section=sectionname&page=pagename ] */
			$url_pieces = parse_url(getenv("REQUEST_URI"));

			if ($url_pieces["query"] != "" && isset($_GET["action"]))
			{
				/* Redirect. Check for url injections */
				header("HTTP/1.1 302 Moved Temporary");
				//$redir = $url_pieces["scheme"] . "://" . $skel["overload_url"] . "feeds.php?feedid=" . $feedid;
				$redir = "feeds.php?feedid=" . $feedid;
				if ($currentpage > 0)
				{
					$redir .= "&page=" . $currentpage;
				}
				header("Location: " . $redir);
				exit;
			}

			$timer_all = $timer;
			$body .= "<!-- " . (getmicrotime() - $timer) . "-->\n";
			$timer = getmicrotime();

			$body .= "<script language=\"JavaScript\" type=\"text/javascript\">\n";
			$body .= "//<![CDATA[\n";
			$body .= "\tvar img_newitem = \"" . $skel["overload_img_newitem"] . "\";\n";
			$body .= "\tvar img_item = \"" . $skel["overload_img_item"] . "\";\n";
			$body .= "\tvar img_flag = \"" . $skel["overload_img_flag"] . "\";\n";
			$body .= "\tvar img_flagged = \"" . $skel["overload_img_flagged"] . "\";\n";
			$body .= "//]]>\n";
			$body .= "</script>\n";

			$body .= "<script src=\"js/feedreader.js\" language=\"JavaScript\" type=\"text/javascript\"></script>\n";
/*
			$body .= "<div id=\"logo\"><a href=\"feeds.php\">overload</a></div>\n";
			$body .= buildNav($skel);

			$body .= "<!-- " . (getmicrotime() - $timer) . "-->\n";
			$timer = getmicrotime();
			
			$body .= "<div id=\"content\">\n";
			$body .= buildSubnav($skel);
*/
			$currentfeed = null;

			if ($itemid > 0 && $feedid > 0)
			{
				$currentfeed = getFeedForUser($skel, $userid, $feedid);
				$body .= buildFeed($skel, $currentfeed, array(0 => getItem($skel, $userid, $itemid)), 1, 1, true, true);
				//$body .= "<p><em>Reading only one item. Go back one page to see where you came from</em></p>\n";
			} else if ($feedid > 0)
			{
				$currentfeed = getFeedForUser($skel, $userid, $feedid);
				$body .= buildFeed($skel, $currentfeed, getItemsForUser($skel, $userid, $feedid, $offset, $allitems), $currentpage, $totalpages, true);
			} else
			{
				/*
				$body .= "<div id=\"pagebody\">\n";
				$body .= "<h1>Your feeds, " . $_SESSION["username"] . "</h1>\n";
				$body .= "<p>You've got " . getTotalNumberOfUnreadItemsForUser($skel, $userid) . " unread items in your " . getTotalNumberOfFeedsForUser($skel, $userid) . " subscribed feeds</p>\n";
				$body .= "<p>To add a new feed from your favorite website click on the \"Manage feeds\" link above.</p>\n";
				$body .= "<p>If you'd like to read the latest news from each of your subscribed feeds just click on the subscription in the list to the left.</p>\n";
				$body .= "</div>\n";
				*/

				//getRandomItemsForUser($skel, $userid, $nrofitems, $allitems)
				//$body .= "<h2>Random selection of your unread items</h2>\n";
				//$body .= buildFeed($skel, getRandomFeedHeader($skel), getRandomItemsForUser($skel, $userid, 20, false), 1, 1, true);
				//getLatestItemsForUser($skel, $userid, $nrofitems, $allitems);
				//$body .= "<h2>Latest items</h2>\n";
				//$body .= buildFeed($skel, getLatestFeedHeader($skel), getLatestItemsForUser($skel, $userid, 20, false), 1, 1, true);
				$body .= buildFeed($skel, getLatestFeedHeader($skel), getLatestItemsForUser($skel, $userid, $offset, 20, false), $currentpage, $totalpages, true);
				//$body .= buildLatestFeed($skel, getLatestFeedHeader($skel), getLatestItemsForUser($skel, $userid, $offset, 20, false), $currentpage, $totalpages, true);
			}
		}
		$body .= "<!-- " . (getmicrotime() - $timer) . "-->\n";
		$body .= "<!-- All: " . (getmicrotime() - $timer_all) . "-->\n";

		return $body;
	}


	/*
	 * Manage channels, groups, tags and filters
	 */
	function pageManagerVersion() { return "0.0.12"; }
	function pageManagerModified() { return "2006-01-13"; }
	function pageManager($skel, $action, $addtogroup = -1, $feeduri = null, $groupid = -1, $groupname = null)
	{
		$body = "";
		/* Check if user is logged in */
		if (!isLoggedIn())
		{
			//show login page
			$body .= buildNotLoggedIn($skel);
		} else
		{
			$userid = $_SESSION["userid"];

			$errors = "";

			$body .= "<div id=\"pagebody\">\n";
			$body .= "<h1>Manage your feeds and groups</h1>\n";

			if ($action == "addfeed" && $addtogroup > -1 && $feeduri != null)
			{
				$result = addFeed($skel, $userid, $addtogroup, $feeduri, "");
				$body .= "<p>Added feed</p>\n";

				if ($result != "")
				{
					$errors .= "<li>" . $result . "</li>\n";
				}
			} else if ($action == "addgroup")
			{
				if ($groupname != null && $groupname != "")
				{
					$result = addGroup($skel, $userid, $groupname);
					if ($result < 0)
					{
						$errors .= "<li>Something went wrong while adding the new group</li>\n";
					} else
					{
						$body .= "<p>Added group \"" . $groupname . "\"</p>\n";
					}
				} else
				{
					$errors .= "<li>Please fill in a name for the group to add</li>\n";
				}
			}

			//$body .= "<p><a href=\"export.php\">Export to OPML</a> | <a href=\"manager.php?action=import\">Import OPML file</a></p>\n";
			$body .= "<h2>Import / Export</h2>\n";
			$body .= "<p><em>Not yet implemented</em></p>\n";
			//$body .= "<p><input type=\"text\" name=\"opmlfile\" /><input name=\"submitbtn\" value=\"import OPML\" type=\"submit\" class=\"button\" /></p>\n";
			//$body .= "<p><a href=\"export.php\">Export to OPML</a></p>\n";
			$body .= "<p>Select an .opml file [.xml] from you computer to import, or export your current list of feeds</p>\n";
			/*$body .= "<ul>\n";
			$body .= "\t<li><input type=\"file\" name=\"opmlfile\" accept=\"text/xml\" /><input name=\"submitbtn\" value=\"import OPML\" type=\"submit\" class=\"button\" /></li>\n";
			$body .= "\t<li><a href=\"export.php\">Export to OPML</a></li>\n";
			$body .= "</ul>\n";*/
			$body .= "\t<p><input type=\"file\" name=\"opmlfile\" accept=\"text/xml\" /><input name=\"submitbtn\" value=\"import OPML\" type=\"submit\" class=\"button\" /></p>\n";
			$body .= "\t<p><a href=\"export.php\" class=\"buttonlink\">Export to OPML</a></p>\n";


			$groups = getGroups($skel, $userid);

			$body .= "<form action=\"manager.php?action=addfeed\" method=\"post\">\n";
			$body .= "<h2>Add feed</h2>\n";
			$body .= "<p>Fill in the <acronym title=\"Universal Resource Identifier, internet address\">URI</acronym> of the feed</p>\n";
			$body .= "<p><input type=\"text\" name=\"feeduri\" /> to " . buildGroupBox($skel, "addtogroup", $groups) . "<input name=\"submitbtn\" value=\"add\" type=\"submit\" class=\"button\" /></p>\n";
			$body .= "</form>\n";

			$body .= "<form action=\"manager.php?action=changegroup\" method=\"post\">\n";
			$body .= "<h2>Groups</h2>\n";
			$body .= "<p><em>Not yet implemented</em></p>\n";
			$body .= "<p>Select a group to rename</p>\n";
			//$body .= "<form action=\"manager.php?action=deletegroup\" method=\"post\">\n";
			//$body .= buildGroupBox($skel, getGroups($skel, $userid));
			$body .= buildGroupList($skel, $groups);
			$body .= "</form>\n";

			$body .= "<form action=\"manager.php?action=addgroup\" method=\"post\">\n";
			$body .= "<h2>Add group</h2>\n";
			$body .= "<p><input type=\"text\" name=\"groupname\" /><input name=\"submitbtn\" value=\"add group\" type=\"submit\" class=\"button\" /></p>\n";
			$body .= "</form>\n";

			$body .= "<h2>Feeds</h2>\n";
			$body .= "<p><em>Not yet implemented</em></p>\n";

			if ($errors != "")
			{
				$body .= "<h2>Something went wrong</h2>\n";
				$body .= "<ul>\n";
				$body .= $errors;
				$body .= "</ul>\n";
			}

			$body .= "</div>\n";

		/*
			if ($feedid > 0)
			{
				$body .= buildFeed($skel, getFeed($skel, $feedid), getItemsForUser($skel, $userid, $feedid));
			} else
			{
				$body .= "<div id=\"pagebody\">\n";
				$body .= "<p>To add a new feed from your favorite website click on the Manage Feeds link above.</p>\n";
			$body .= "<p>If you'd like to read the latest news from each of your subscribed feeds just click on the subscription in the list to the left.</p>\n";
			$body .= "</div>\n";
		}
		*/
		}
		return $body;
	}


	/*
	 * Manage user settings, preferences
	 */
	function pageUserVersion() { return "0.0.06"; }
	function pageUserModified() { return "2005-08-11"; }
	function pageUser($skel, $action, $columnsLight = -1, $columnsRich = -1, $contentRich = -1)
	{
		/* Check if user is logged in */
		if (!isLoggedIn())
		{
			//show login page
			$body .= buildNotLoggedIn($skel);
		} else
		{
			$userid = $_SESSION["userid"];
			$errors = "";

			if ($action == "save")
			{
				//savePreferences($skel, $userid, $stylesheetid, $columnsLight, $columnsRich, $nrItemsLight, $nrItemsRich);
				//savePreferences($skel, $userid, $stylesheetid, $columnsLight, $columnsRich, $contentRich);
				//saveOverloadUser($skel, $userid, $password, $email);
				/* Load the newly setted preferences */
				//loadPreferences($skel, $userid);
				$body .= "<p>You're settings have been saved</p>\n";
			}

/* @TODO: fix overwriting settings */
$_SESSION["overload_stylesheetid"] = $row[0];
			$_SESSION["overload_nrcolumns_html"] = $row[1];
			$_SESSION["overload_nrcolumns_xul"] = $row[2];
			$_SESSION["overload_nritemsperpage_html"] = $row[3];
			$_SESSION["overload_nritemsperpage_xul"] = $row[4];

			$body .= "<div id=\"pagebody\">\n";
			$body .= "<form action=\"user.php?action=save\" method=\"post\">\n";
			$body .= "<h1>Edit your account settings</h1>\n";


			$body .= "<h2>Light version settings</h2>\n";

			$light_single = "";
			$light_two = "";
			if ($skel["overload_nrcolumns_html"] == 1) { $light_single = " selected"; } else { $light_two = " selected"; }
			$body .= "<p><select name=\"columnsLight\"><option value=\"1\"" . $light_single . ">Single column view</option><option value=\"2\"" . $light_two . ">Show items in two columns</option></select></p>\n";


			$body .= "<h2>Rich version [<acronym title=\"XML User-Interface Language\">XUL</acronym>] settings</h2>\n";

			$rich_single = "";
			$rich_two = "";
			if ($skel["overload_nrcolumns_html"] == 1) { $rich_single = " selected"; } else { $rich_two = " selected"; }
			$body .= "<p><select name=\"columnsRich\"><option value=\"1\"" . $rich_single . ">Show items in a single column</option><option value=\"2\"" . $rich_two . ">Use two columns</option></select>&nbsp;";
			
			$rich_overloadpage = "";
			$rich_originalpage = "";
			if ($skel["overload_nrcolumns_html"] == 1) { $rich_single = " selected"; } else { $rich_two = " selected"; }
			$body .= "<select name=\"contentRich\"><option value=\"1\"" . $rich_overloadpage . ">Show item styled in the overload way</option><option value=\"2\"" . $rich_originalpage . ">Show the original posting in the content pane</option></select></p>\n";


			$body .= "<h2>Personal settings</h2>\n";
			$body .= "<h3>Your e-mail address</h3>\n";
			$body .= "<p><input type=\"text\" name=\"email\" value=\"" . $emailaddress . "\" /></p>\n";

			$body .= "<h3>Change your password</h3>\n";
			$body .= "<p><input type=\"password\" name=\"password\"/>&nbsp;";
			//$body .= "<h3>[Retype]</h3>\n";
			$body .= "again: <input type=\"password\" name=\"password2\"/></p>\n";


			$body .= "<h2>Type your current password</h2>\n";
			$body .= "<p><input type=\"password\" name=\"currentpassword\"/></p>\n";



			$body .= "<p><input name=\"submitbtn\" value=\"save\" type=\"submit\" class=\"button\" /><input name=\"reset\" type=\"reset\" value=\"reset to current\"/></p>\n";
			$body .= "</form>\n";

			if ($errors != "")
			{
				$body .= "<h2>Something wasn't right</h2>\n";
				$body .= "<ul>\n";
				$body .= $errors;
				$body .= "</ul>\n";
			}

			$body .= "</div>\n";
		}
		return $body;
	}


/* --- */

	function buildNotLoggedIn($skel)
	{
		$result  = "<div id=\"pagebody\">\n";
		$result .= "<h1>Not logged in</h1><p><a href=\"./\">Go to login page</a></p>\n";
		$result .= "</div>\n";
		return $result;
	}

	function buildPdaNotLoggedIn($skel)
	{
		$result  = "<div id=\"pagebody\">\n";
		$result .= "<h1>No or invalid usercode provided</h1><p>If you want to use the pda version, please use the uri as follows: pda.php?usercode=1234567890 [your unique code is available in the <a href=\"user.php\">Account page</a>].</p><p>Or <a href=\"./\">go to the login page</a></p>\n";
		$result .= "</div>\n";
		return $result;
	}
?>
