<?php

	/*
	 * User management related functions, extensions for overload rss reader
	 * v0.0.05 2005-08-11
	 */

	/* Register this module so mod_overload knows it can load user preferences */
	$usermodule = true;

	require ("mod_user.php");


	/*
	 * Add new overload user
	 */
	function addOverloadUser($skel, $username, $password, $email, $ip)
	{
		$error = "";

		$result = addUser($skel, $username, $password, $email, $ip);
		if (is_int($result))
		{
			$userid = $result;
			if ($userid == 0)
			{
				$userid = -1;
				$error = "Error while adding user";
			} else
			{
				/* Adding user succeeded, now create default prefences and feed group [tag] for this user */
				addPreferences($skel, $userid);
				$result = addGroup($skel, $userid, "feeds");
				sendSubscribeMail($skel, $email, $userid, $username, $password);
				if ($skel["overload_email_on_new_user"])
				{
					sendAdminSubscribeMail($skel, $email, $userid, $username, $password);
				}
				//@TODO: log!
			}
		} else
		{
			$error = $result;
		}
		return $error;
	}


	/*
	 * Save modified $password / $email
	 */
	function saveOverloadUser($skel, $userid, $password, $email)
	{
		//
	}


	/*
	 * Add preferences for new user
	 */
	function addPreferences($skel, $userid)
	{
		$timestamp = date("Y-m-d G:i:s", time());
		$query = 'INSERT INTO overload_preferences ' .
			'SET userid=' . $userid . ', ' .
			'stylesheetid=1, ' .
			'nrcolumns_html=1, ' .
			'nrcolumns_xul=1;';
		$result = doQuery($skel, $query);
	}


	/*
	 * Load preferences of user into session
	 */
	function loadPreferences($skel, $userid)
	{
		$query = 'SELECT stylesheetid, nrcolumns_html, nrcolumns_xul, nritemsperpage_html, nritemsperpage_xul FROM overload_preferences ' .
			'WHERE userid=' . $userid . ';';
		$result = doQuery($skel, $query);

		if ( mysql_num_rows( $result ) > 0 )
		{
			$row = mysql_fetch_row($result);
			$_SESSION["overload_stylesheetid"] = $row[0];
			$_SESSION["overload_nrcolumns_html"] = $row[1];
			$_SESSION["overload_nrcolumns_xul"] = $row[2];
			$_SESSION["overload_nritemsperpage_html"] = $row[3];
			$_SESSION["overload_nritemsperpage_xul"] = $row[4];

			return $userid;
		} else
		{
			/* Preferences fo user not found */
			return -1;
		}
	}

	/*
	 * Save preferences
	 */
	function savePreferences($skel, $userid, $stylesheetid, $columnsLight, $columnsRich, $contentRich, $nrItemsLight = 20, $nrItemsRich = 20)
	{
		$timestamp = date("Y-m-d G:i:s", time());
		$query = 'INSERT INTO overload_preferences ' .
			'SET userid=' . $userid . ', ' .
			'stylesheetid=1, ' .
			'nrcolumns_html=1, ' .
			'nrcolumns_xul=1;';
		$result = doQuery($skel, $query);
	}
?>
