<?php
	header("content-type:text/plain; charset=utf8");
	//header('Content-type: text/html; charset=utf8');

	require ("../config.php");
	require ("../modules/mod_db.php");
	require ("../modules/mod_toolkit.php");
	require ("../modules/mod_overload_user.php");
	require ("../modules/mod_overload.php");
	require ("../modules/mod_overload_xul.php");
	require ("../modules/mod_overload_html.php");

	$skel["overload_xul_actions_version"] = "0.0.06";
	$skel["overload_xul_actions_lastmodified"] = "2006-01-09";

	define ('ITEMS_NEW', 1);
	define ('ITEMS_ONLYSAVED', 2);
	define ('ITEMS_ALL', 3);

	if (!isLoggedIn())
	{
		if (isset($_REQUEST["action"]))
		{
			$action = $_REQUEST["action"];
			if ($action == "login" && isset($_REQUEST["user"]) && isset($_REQUEST["pass"]))
			{
				$userid = login($skel, $_REQUEST["user"], $_REQUEST["pass"]);
				if ($userid > 0)
				{
					/* Login successfull! */
					/* Start new session */
					session_name($skel["session_name"]);
					session_start();
					$_SESSION['username'] = $_REQUEST["user"];
					$_SESSION['userid'] = $userid;
					loadPreferences($skel, $userid);
					echo "success";
				}
				exit;
			}
		}
		header("HTTP/1.1 403 Not logged in");
		echo "loggedout";
		exit;
	}

	$userid = $_SESSION["userid"];

	function clientGetItems($skel, $userid, $feedid, $filter)
	{
		$offset = 0;
		$allitems = false;
		if ($filter == ITEMS_ALL)
		{
			/* Show _all_ items [expensive!] */
			$allitems = true;
			$filtersaved = false;
		} else if ($filter == ITEMS_ONLYSAVED)
		{
			$allitems = true;
			$filtersaved = true;
		} else
		{
			/* Show only the new items */
			$allitems = false;
			$filtersaved = false;
		}

		$items =  getItemsForUser($skel, $userid, $feedid, $offset, $allitems, false, $filtersaved);
		return itemsToXULClientStruct($items);
	}



	if (isset($_REQUEST["action"]))
	{
		$action = $_REQUEST["action"];
		//
		if ($action == "getfeeds")
		{
			$result = "data={\n";
			
			$feeds = getFeeds($skel, $userid);
			$groups = getGroups($skel, $userid);

			$result .= " catcount:" . count($groups) . ",\n";
			$result .= " categories:[";
			for ($i = 0; $i < count($groups); $i++)
			{
				$result .= "'" . $groups[$i]["name"] . "'";
				if ($i < (count($groups) - 1))
				{
					$result .= ",";
				}
			}
			$result .= "],\n";
			$result .= " rowcount:" . count($feeds) . ",\n";
			$result .= " table:[\n";
			for ($i = 0; $i < count($feeds); $i++)
			{
				$feedname = html_entity_decode($feeds[$i]["feedname"]);
				if ($feeds[$i]["userfeedname"] != "")
				{
					$feedname = $feeds[$i]["userfeedname"];
				}
				$feedname = str_replace("'", "\'", $feedname);
				$result .= " [" . $feeds[$i]["id"] . ",";
				$result .= "'" . $feedname . "',";
				//$result .= "'" . $feeds[$i]["subtitle"] . "',";
				$result .= "'',";
				$result .= "'" . $feeds[$i]["uri"] . "',";
				$result .= "'RSS',";
				$result .= "'" . $feeds[$i]["groupname"] . "']";
				if ($i < (count($feeds) - 1))
				{
					$result .= ",";
				} else
				{
					$result .= "]";
				}
				$result .= "\n";
			}
			$result .= "}\n";

			echo $result;
		} else if ($action == "getitems" && isset($_REQUEST["feedid"]) && $_REQUEST["feedid"] > 0)
		{
			$feedid = $_REQUEST["feedid"];
			echo clientGetItems($skel, $userid, $feedid, ITEMS_NEW);
		} else if ($action == "getsaveditems" && isset($_REQUEST["feedid"]) && $_REQUEST["feedid"] > 0)
		{
			$feedid = $_REQUEST["feedid"];
			echo clientGetItems($skel, $userid, $feedid, ITEMS_ONLYSAVED);
		} else if ($action == "getallitems" && isset($_REQUEST["feedid"]) && $_REQUEST["feedid"] > 0)
		{
			$feedid = $_REQUEST["feedid"];
			echo clientGetItems($skel, $userid, $feedid, ITEMS_ALL);
		} else if ($action == "markitemread" && isset($_REQUEST["itemid"]) && $_REQUEST["itemid"] > 0)
		{
			$itemid = $_REQUEST["itemid"];
			setItemsRead($skel, $userid, $itemid);
			//echo "marked item with id " . $itemid . " as 'read'";
			/*
			header("HTTP/1.1 302 Moved Temporary");
			$redir = "../xul_show.php?action=getitem&itemid=" . $itemid;
			header("Location: " . $redir);
			*/
			echo "ok";
		} else if ($action == "markitemunread" && isset($_REQUEST["itemid"]) && $_REQUEST["itemid"] > 0)
		{
			$itemid = $_REQUEST["itemid"];
			setItemsUnread($skel, $userid, $itemid);
			/*
			header("HTTP/1.1 302 Moved Temporary");
			$redir = "../xul_show.php?action=getitem&itemid=" . $itemid;
			header("Location: " . $redir);
			*/
			echo "ok";
		} else if ($action == "markitemsread" && isset($_REQUEST["items"]) && $_REQUEST["items"] != ""  && isset($_REQUEST["feedid"]) && $_REQUEST["feedid"] > 0)
		{
			$items = $_REQUEST["items"];
			$feedid = $_REQUEST["feedid"];

			/* First set $items in the right format */
			/*
			$itemsArray = explode(",", $items);
			$items = implode(" ", $itemsArray);
			*/
			$items = str_replace(",", " ", $items);
			setItemsRead($skel, $userid, $items);

			echo clientGetItems($skel, $userid, $feedid, ITEMS_NEW);
		} else if ($action == "saveitem" && isset($_REQUEST["itemid"]) && $_REQUEST["itemid"] > 0)
		{
			$itemid = $_REQUEST["itemid"];
			saveItem($skel, $userid, $itemid);
			/*
			header("HTTP/1.1 302 Moved Temporary");
			$redir = "../xul_show.php?action=getitem&itemid=" . $itemid;
			header("Location: " . $redir);
			*/
			echo "ok";
		} else if ($action == "unsaveitem" && isset($_REQUEST["itemid"]) && $_REQUEST["itemid"] > 0)
		{
			$itemid = $_REQUEST["itemid"];
			unsaveItem($skel, $userid, $itemid);
			/*
			header("HTTP/1.1 302 Moved Temporary");
			$redir = "../xul_show.php?action=getitem&itemid=" . $itemid;
			header("Location: " . $redir);
			*/
			echo "ok";
		} else if ($action == "find" && isset($_REQUEST["query"]) && $_REQUEST["query"] != "")
		{
			$query = $_REQUEST["query"];

			$items = findItems($skel, $userid, $query);
			echo itemsToXULClientStruct($items);
		} else if ($action == "logout")
		{
			logout($skel);
			echo "ok";
		} else
		{
			echo "Error: unknown action";
		}
	}

	//$feeds = getFeeds($skel, $_SESSION["userid"]);
?>
