<?php

	/*
	 * created @ 2006-01-21
	 * version 0.3 2006-01-23
	 */

	rm($webpath . "section.desc");
	$sectionsfile = fopen($webpath . "section.desc", "a");
	$firstfile = true;
	for ($i = 0; $i < count($logfiles); $i++)
	{
		$logfilekey = str_replace("#", "", $logfiles[$i]);
		echo date("== Y-m-d G:i:s ======\n");
		echo "processing " . $logfilekey . "...\n";
		fwrite($sectionsfile, $logfilekey . "=" . $logfiles[$i] . "\n");
		if (rm($webpath . "pages/" . $logfilekey . "_*"))
		{
			echo "deleting " . $webpath . "sections/" . $logfilekey . ".desc\n";
			rm($webpath . "sections/" . $logfilekey . ".desc");
			$sectionfile = fopen($webpath . "sections/" . $logfilekey . ".desc", "a");
			//$logfile = file($logpath . $logfiles[$i]);
			echo "opening " . $logpath . $logfiles[$i] . "...\n";
			//$logfile = file_get_contents($logpath . $logfiles[$i]);
			$logfile = fopen($logpath . $logfiles[$i], "r");

			$newfile = false;
			while (!feof($logfile))
			{
				$line = fgets($logfile);
				//if (!strpos("--- Log opened ", $line))
				if (strpos($line, "--- Log opened ") !== false)
				{
					$newfile = true;
					$line = substr($line, strlen("--- Log opened "));
					//echo $line . "\n";
				}
				if (strpos($line, "--- Day changed ") !== false)
				{
					$newfile = true;
					$line = substr($line, strlen("--- Day changed "));
					//echo $line . "\n";
				}
				if ($newfile)
				{
					$newfile = false;
					if (!$firstfile)
					{
						fclose($file);	//close previous file
					} else
					{
						$firstfile = false;
					}
					//$title = substr($subpieces[$s], 0, strpos($subpieces[$s], "\n"));
					$title = trim($line);
					$filename = str_replace(" ", "_", $title);
					$filename = str_replace(":", "", $filename);
					fwrite($sectionfile, $filename . "=" . $title . "\n");
					$file = fopen($webpath . "pages/" . $logfilekey . "_" . $filename . ".html" , "a");
				}
				$line = htmlentities($line);
				//$line = str_replace("\n", "<br />\n", $line);
				$line = trim($line);
				if ($line != "")
				{
					$line = $line . "<br />\n";
					if (!fwrite($file, $line))
					{
						echo "Error while writing to '" . $webpath . "pages/" . $logfilekey . "_" . $filename . "'\n";
					}
				}
			}
			echo "closing " . $logpath . $logfiles[$i] . "\n";
			fclose($logfile);
			echo "closing " . $webpath . "sections/" . $logfilekey . ".desc\n";
			fclose($sectionfile);
		}
	}
	echo "closing " . $webpath . "section.desc\n";
	fclose($sectionsfile);



/* Source: php.net/unlink */

/**
 * rm() -- Vigorously erase files and directories.
 *
 * @param $fileglob mixed If string, must be a file name (foo.txt), glob pattern (*.txt), or directory name.
 *                        If array, must be an array of file names, glob patterns, or directories.
 */
function rm($fileglob)
{
   if (is_string($fileglob)) {
       if (is_file($fileglob)) {
           return unlink($fileglob);
       } else if (is_dir($fileglob)) {
           $ok = rm("$fileglob/*");
           if (! $ok) {
               return false;
           }
           return rmdir($fileglob);
       } else {
           $matching = glob($fileglob);
           if ($matching === false) {
               trigger_error(sprintf('No files match supplied glob %s', $fileglob), E_USER_WARNING);
               return false;
           }     
           $rcs = array_map('rm', $matching);
           if (in_array(false, $rcs)) {
               return false;
           }
       }     
   } else if (is_array($fileglob)) {
       $rcs = array_map('rm', $fileglob);
       if (in_array(false, $rcs)) {
           return false;
       }
   } else {
       trigger_error('Param #1 must be filename or glob pattern, or array of filenames or glob patterns', E_USER_ERROR);
       return false;
   }

   return true;
}


/*
 * A short but powerfull recursive function that works also if the dirs contain hidden files
 */
function SureRemoveDir($dir) {
   if(!$dh = @opendir($dir)) return;
   while (($obj = readdir($dh))) {
     if($obj=='.' || $obj=='..') continue;
     if (!@unlink($dir.'/'.$obj)) {
         SureRemoveDir($dir.'/'.$obj);
     } else {
         $file_deleted++;
     }
   }
   if (@rmdir($dir)) $dir_deleted++;
}

?>
